import Utilities.gui_creator as gc
import Utilities.nidaq_operations as no

root = gc.create_window('DC Voltage Source',
                        size='300x100')

channel_name = 'Dev1/ao0'
task = no.create_ao_task(channel_name)

var_ent = gc.create_control(root,
                            label='Input Voltage')

def generate_sample():    

    string_data = gc.get_control_string(var_ent)
    float_data = float(string_data)

    task.write(float_data)

    return

btn = gc.action_button(root, label='Write Sample',
                       action=generate_sample)

root.mainloop()

task.close()

